package gov.va.med.mhv.usermgmt.main.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.step.item.FaultTolerantChunkProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.common.data.model.Facility;
import gov.va.med.mhv.common.data.model.FacilityInfo;
import gov.va.med.mhv.common.data.model.InPersonAuthentication;
import gov.va.med.mhv.common.data.model.Patient;
import gov.va.med.mhv.common.data.model.PatientRegistryChange;
import gov.va.med.mhv.common.data.model.UserProfile;
import gov.va.med.mhv.mvi.xsd.CS;
import gov.va.med.mhv.mvi.xsd.II;
import gov.va.med.mhv.mvi.xsd.MCCIIN000002UV01Document.MCCIIN000002UV01;
import gov.va.med.mhv.mvi.xsd.MCCIMT000200UV01Acknowledgement;
import gov.va.med.mhv.mvi.xsd.MCCIMT000200UV01AcknowledgementDetail;
import gov.va.med.mhv.mvi.xsd.PRPAIN201305UV02Document;
import gov.va.med.mhv.mvi.xsd.PRPAIN201305UV02Document.PRPAIN201305UV02;
import gov.va.med.mhv.mvi.xsd.PRPAIN201306UV02Document.PRPAIN201306UV02;
import gov.va.med.mhv.mvi.xsd.PRPAIN201306UV02MFMIMT700711UV01Subject1;
import gov.va.med.mhv.mvi.xsd.PRPAIN201310UV02Document.PRPAIN201310UV02;
import gov.va.med.mhv.mvi.xsd.PRPAIN201310UV02MFMIMT700711UV01Subject1;
import gov.va.med.mhv.mvi.xsd.PRPAMT201304UV02Patient;
import gov.va.med.mhv.mvi.xsd.PRPAMT201310UV02OtherIDs;
import gov.va.med.mhv.mvi.xsd.PRPAMT201310UV02Patient;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActorTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.AuthenticationStatusEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.PatientCorrelationStatusEnumeration;
import gov.va.med.mhv.usermgmt.data.repository.FacilityInfoRepository;
import gov.va.med.mhv.usermgmt.data.repository.FacilityRepository;
import gov.va.med.mhv.usermgmt.data.repository.UserProfileRepository;
import gov.va.med.mhv.usermgmt.service.ActivityService;
import gov.va.med.mhv.usermgmt.service.InPersonAuthenticationService;
import gov.va.med.mhv.usermgmt.service.MviAsyncIntegrationService;
import gov.va.med.mhv.usermgmt.service.PatientService;
import gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser;
import gov.va.med.mhv.usermgmt.service.handler.MviInvocationUtilHandler;
import gov.va.med.mhv.usermgmt.service.handler.MviProperties;
import gov.va.med.mhv.usermgmt.util.MessagesUtil;
import gov.va.med.mhv.usermgmt.util.mvi.CreateMVICorrelationRequest;
import gov.va.med.mhv.usermgmt.util.mvi.CreateMVIGetCorrespondingRequest;
import gov.va.med.mhv.usermgmt.util.mvi.CreateMVIPatientSearchRequest;
import gov.va.med.mhv.usermgmt.util.mvi.MviRequestTypeEnum;
import gov.va.med.mhv.usermgmt.util.mvi.MviResponseTypeEnum;
import gov.va.med.mhv.usermgmt.util.mvi.MviUtil;

/**
 * Service implementation class for the MviAsyncIntegration service
 * @see gov.va.med.mhv.usermgmt.service.MviAsyncIntegrationService
 */
@Component
public class MviAsyncIntegrationServiceImpl implements MviAsyncIntegrationService {

	private static final Log log = LogFactory.getLog(MviAsyncIntegrationServiceImpl.class);

	@Autowired
	private MviInvocationUtilHandler mviInvokeHandler;

	@Autowired
	private MviProperties mviProperties;

	@Autowired
	private PatientService patientService;

	@Autowired
	private UserProfileRepository userProfileRepository;

	@Autowired
	private FacilityRepository facilityRepository;
	
	@Autowired
	private FacilityInfoRepository facilityInfoRepository;
	
	@Autowired
	private InPersonAuthenticationService ipaService;

	@Autowired
	private CreateMVIPatientSearchRequest createMVIPatientSearchRequest;

	@Autowired
	private CreateMVICorrelationRequest createMVICorrelationRequest;

	@Autowired
	private CreateMVIGetCorrespondingRequest createMVIGetCorrespondingRequest;

	@Autowired
	private MviInvocationUtilHandler mviInvocationUtilHandler;

	@Autowired
	private ActivityService activityService;

	@Autowired
	private MessagesUtil messagesUtil;

	private String getPatientFullName(Patient patient) {
		StringBuffer fullName = new StringBuffer(patient.getUserProfile().getFirstName());

		// Admin Portal_CodeCR1789 - Make sure that there is a space in between
		// First and Last Names.
		if (patient.getUserProfile().getMiddleName() != null) {
			fullName.append(" " + patient.getUserProfile().getMiddleName());
		}
		fullName.append(" " + patient.getUserProfile().getLastName());
		return fullName.toString();
	}

	/**
	 * Execute the AddPersonForCorrelation service
	 * @see gov.va.med.mhv.usermgmt.service.MviAsyncIntegrationService#AddPersonForCorrelation()
	 */
	@SuppressWarnings("unused")
	@Transactional
	public void addPersonForCorrelation(Patient patient, UserProfile userProfile, Boolean isRegistration, ResponseUtil response, String versionInfo) {
		if (log.isDebugEnabled()) {
			log.debug("inside addPersonForCorrelation()...");
		}
		MCCIIN000002UV01 searchCorrelRes = null;

		// Service business logic here
		if(patient == null || patient.getIcn() == null) {
			if (log.isErrorEnabled()) {
				log.error("Not Invoking Correlation Call because Patient object OR ICN is NULL: ");
				if(patient != null)
					log.error("ICN is Empty: " +patient.getIcn());
			}
			response.setFailure(true);
			response.setSuccess(false);
			response.setFailureMessage("Not Invoking Correlation Call because Patient object OR ICN is NULL");
			return;
		}

		//patient.setCorrelationStatus(PatientCorrelationStatusUtils.PENDING_CORRELATION);
		//patient.setCorrelateRequestDate(Calendar.getInstance().getTime());
		patient.setCorrelateRequestDateTime(new Timestamp(System.currentTimeMillis()));
		//PatientServiceResponse psr = ServiceFactory.createEntityMaintenanceService().save(patient);

		Object correlationReqXML = createMVICorrelationRequest.createCorrelationXMLRequest(userProfile, patient, mviProperties, versionInfo);
		String responseXMLString = mviInvocationUtilHandler.invokeMvi(MviRequestTypeEnum.ADDCORRELATION_TYPE.getReqType(), correlationReqXML);
		MVIMessageParser messageParser = new MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.ADDCORRELATION_TYPE.getReqType(), (String)correlationReqXML, responseXMLString);
		Set<Facility> facilities = null;
		if(searchObj ==null) {
			if (log.isErrorEnabled()) {
				log.error("UNABLE TO PARSE THE CORRELATION RESPONSE FROM MVI For the ICN: "+patient.getIcn());
			}
			response.setFailure(true);
			response.setSuccess(false);
			response.setFailureMessage("UNABLE TO PARSE THE CORRELATION RESPONSE FROM MVI For the ICN: "+patient.getIcn());
			return;
		} else {
			searchCorrelRes = (MCCIIN000002UV01)searchObj;
			MCCIMT000200UV01Acknowledgement[] acknowledgementArray = searchCorrelRes.getAcknowledgementArray();
			MCCIMT000200UV01Acknowledgement acknowledgement = null;
			//Array should have only 1 ACK
			acknowledgement = acknowledgementArray[0];

			if(acknowledgement.getTypeCode().getCode().equals("AA")) {
				MCCIMT000200UV01AcknowledgementDetail[] acknowledgementDetailArray = acknowledgement.getAcknowledgementDetailArray();
				MCCIMT000200UV01AcknowledgementDetail acknowledgementDetail = acknowledgementDetailArray[0];
				patient.setCorrelatedDateTime(new Timestamp(Calendar.getInstance().getTime().getTime()));
				patient.setCorrelationStatus(PatientCorrelationStatusEnumeration.CORRELATED.getValue());
				/*gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(patient);
				response.setPatient(patient);*/

				Patient savedPatient1 = patientService.savePatient(patient);
				response.setPojoObject(savedPatient1);

				String fullName = getPatientFullName(patient);

				response.getInfoMessages().put(messagesUtil.getMviIpaCorrelationSuccess(), String.format(messagesUtil.getMviIpaCorrelationSuccess(), fullName));

				// activityService.auditMviLoginEvent(userProfile.getId(),ActivityActorTypeEnumeration.SYSTEM,true,
				// ActivityActionTypeEnumeration.CONNECTED_TO_VA_RECORD);
				// MHV_CodeCR1856 - Made sure that MHV_AUTHENTICATOR displays instead of SYSTEM
				if(!isRegistration) {
					activityService.auditMviEvent(
						userProfile, ActivityActorTypeEnumeration.MHV_AUTHENTICATOR, true, ActivityActionTypeEnumeration.CONNECTED_TO_VA_RECORD,
						ActivityTypeEnumeration.ACCOUNT_UPGRADE, response);
				}
				ipaService.getIPAPatientById(patient.getId(), response);
				InPersonAuthentication ipa = (InPersonAuthentication) response.getPojoObject();

				if (null != ipa && null != ipa.getStatus() && ipa.getStatus().equalsIgnoreCase(AuthenticationStatusEnumeration.AUTHENTICATED.getDescription())) {
					ipa.setMviAuthenticationStatus("PENDING_AUTH");
					ipa.setStatus(AuthenticationStatusEnumeration.AUTHENTICATED.getDescription());
					// ServiceFactory.createEntityMaintenanceService().save(ipa);
					InPersonAuthentication savedIpa = ipaService.saveIPA(ipa);

					patient.setPatientSynchronizations(null);
					// ServiceFactory.createEntityMaintenanceService().save(patient);
					Patient savedPatient2 = patientService.savePatient(patient);
					response.setPojoObject(savedPatient2);
				}

//				facilities = updateTreatmentFacilitiesForExistingPatientsNoSave(savedPatient1, response);
			}
			else {
				patient.setCorrelationStatus(PatientCorrelationStatusEnumeration.FAILEDCORRELATION.getValue());
			}
		}

		Patient savedPatient = patientService.savePatient(patient);
		if(facilities != null) {
			for (Facility facility : facilities) {
				facility.setPatient(savedPatient);
				facilityRepository.save(facility);
			}
		}
		response.setPojoObject(savedPatient);
		return;
	}

	private Set<Facility> updateTreatmentFacilitiesForExistingPatientsNoSave(Patient patient, ResponseUtil response) {
		//Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
		Set<Facility> facilities = null;
		String versionInfo ="family=" + MviUtil.VERSION_INFO_JOB_GET_IDS;
		Object correspondingReqXML = createMVIGetCorrespondingRequest.createMVIGetCorrespondingRequest(patient.getIcn(), mviProperties, versionInfo);

		String corresResponseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.GETCORRESPONDING_TYPE.getReqType(), correspondingReqXML);
		MVIMessageParser messageParser = new MVIMessageParser();
		PRPAIN201310UV02 searchCorresRes =
			(PRPAIN201310UV02) messageParser.mVIMessageParser(
				MviRequestTypeEnum.GETCORRESPONDING_TYPE.getReqType(), (String) correspondingReqXML, corresResponseXMLString);

		if (searchCorresRes != null && searchCorresRes.getControlActProcess().getSubjectArray() != null &&
			searchCorresRes.getControlActProcess().getSubjectArray().length > 0) {
			PRPAIN201310UV02MFMIMT700711UV01Subject1[] subjectArray = searchCorresRes.getControlActProcess().getSubjectArray();
			if (subjectArray[0].getRegistrationEvent() != null) {
				PRPAMT201304UV02Patient corresPatient = subjectArray[0].getRegistrationEvent().getSubject1().getPatient();
				II[] patientIdArray = corresPatient.getIdArray();
				facilities = processFacilityChanges(receivedFacilitiesFromMvi(patientIdArray), patient, patient.getUserProfile());
			}
			if (log.isDebugEnabled()) {
				log.debug("DEBUG MESSAGE: updateTreatmentFacilitiesForExistingPatients:searchCorresRes for patient: " + patient.getUserProfile().getUserName());
			}
			// TODO: unable to find mvi.treatment.facilities.rxrefill.success in any property file
			// addInfo(ptResponse, "mvi.treatment.facilities.rxrefill.success", new String[] {patient.getUserProfile().getUserName()});
		} else {
			log.error("ERROR: updateTreatmentFacilitiesForExistingPatients:searchCorresRes for patient: " + patient.getUserProfile().getUserName());
			// TODO: unable to find mvi.treatment.facilities.rxrefill.error in any property file
			// addError(ptResponse, "mvi.treatment.facilities.rxrefill.error", new String[] {patient.getUserProfile().getUserName()});
		}

		patient.setLastFacilitiesUpdateDateTime(new Timestamp(Calendar.getInstance().getTime().getTime()));
		return facilities;
	}

	public void updateTreatmentFacilitiesForExistingPatients(Patient patient, ResponseUtil response) {
		//Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
		String versionInfo ="family=" + MviUtil.VERSION_INFO_JOB_GET_IDS;
		Object correspondingReqXML = createMVIGetCorrespondingRequest.createMVIGetCorrespondingRequest(patient.getIcn(), mviProperties, versionInfo);

		String corresResponseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.GETCORRESPONDING_TYPE.getReqType(), correspondingReqXML);
		MVIMessageParser messageParser = new MVIMessageParser();
		PRPAIN201310UV02 searchCorresRes =
			(PRPAIN201310UV02) messageParser.mVIMessageParser(
				MviRequestTypeEnum.GETCORRESPONDING_TYPE.getReqType(), (String) correspondingReqXML, corresResponseXMLString);

		if (searchCorresRes != null && searchCorresRes.getControlActProcess().getSubjectArray() != null &&
			searchCorresRes.getControlActProcess().getSubjectArray().length > 0) {
			PRPAIN201310UV02MFMIMT700711UV01Subject1[] subjectArray = searchCorresRes.getControlActProcess().getSubjectArray();
			if (subjectArray[0].getRegistrationEvent() != null) {
				PRPAMT201304UV02Patient corresPatient = subjectArray[0].getRegistrationEvent().getSubject1().getPatient();
				II[] patientIdArray = corresPatient.getIdArray();
				processFacilityChanges(receivedFacilitiesFromMvi(patientIdArray), patient, patient.getUserProfile());
			}
			if (log.isDebugEnabled()) {
				log.debug("DEBUG MESSAGE: updateTreatmentFacilitiesForExistingPatients:searchCorresRes for patient: " + patient.getUserProfile().getUserName());
			}
			// TODO: unable to find mvi.treatment.facilities.rxrefill.success in any property file
			// addInfo(ptResponse, "mvi.treatment.facilities.rxrefill.success", new String[] {patient.getUserProfile().getUserName()});
		} else {
			log.error("ERROR: updateTreatmentFacilitiesForExistingPatients:searchCorresRes for patient: " + patient.getUserProfile().getUserName());
			// TODO: unable to find mvi.treatment.facilities.rxrefill.error in any property file
			// addError(ptResponse, "mvi.treatment.facilities.rxrefill.error", new String[] {patient.getUserProfile().getUserName()});
		}

		patient.setLastFacilitiesUpdateDateTime(new Timestamp(Calendar.getInstance().getTime().getTime()));

		// ptResponse = gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(patient);

System.out.println("############################################################## MviAsync.updateTreatmentFacilitiesForExistingPatients calling patientService.savePatient");		    		
		Patient savedPatient = patientService.savePatient(patient);
		response.setPojoObject(savedPatient);
		return;
	}
	/*
	 * (non-Javadoc)
	 * @see gov.va.med.mhv.usermgmt.service.MviAsyncIntegrationService#existingUserWithPendingDataMismatch(UserProfile)
	 * This will cover all existing user scenarios that exist in evault before 12.4 March MVI Compliance release
	 */
	@Transactional
	public void existingUserWithPendingDataMismatch(UserProfile userProfile, ResponseUtil response) {

		if(!mviProperties.isMviEnabled()) {
			// USER STORY 11: Treatment Facilities event from MHV Compliance to MVI REQUIREMENTS Draft_11_3.doc
			patientService.updatePatientFacilities(StringUtils.lowerCase(userProfile.getUserName()), userProfile, mviProperties.isMviEnabled(), response);
		}


		PRPAIN201306UV02 searchRes = null;

		Patient existingPatient = null;
		patientService.getPatientForUser(userProfile, response);
		// verify response has no errors
		if (response.isFailure()) {
			return;
		}
		existingPatient = (Patient) response.getPojoObject();

		Patient vetPatient = null;
		Object searchReqXML = createMVIPatientSearchRequest.createPatientSearchXMLRequest(userProfile, mviProperties, MviUtil.getVersionInfo(userProfile));
		String responseXMLString = mviInvocationUtilHandler.invokeMvi(MviRequestTypeEnum.SEARCH_TYPE.getReqType(), searchReqXML);
		if (responseXMLString.equalsIgnoreCase("ERROR")) {
			log.error("Error in MVI search response" + responseXMLString);
			response.setFailureMessage("Error in MVI search response");
			response.setSuccess(false);
			response.setFailure(true);
			return;
		}
		// MVI search response has no error
		MVIMessageParser messageParser = new MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.SEARCH_TYPE.getReqType(), (String)searchReqXML, responseXMLString);

		if(searchObj != null) {
			searchRes = (PRPAIN201306UV02)searchObj;
		} else {
			log.error("UNABLE TO PARSE THE SEARCH RESPONSE FROM MVI");
			response.setFailureMessage("UNABLE TO PARSE THE SEARCH RESPONSE FROM MVI");
			response.setSuccess(false);
			response.setFailure(true);
			return;
		}

		String ICNFromMviResponse = null;
		CS queryResponseCode = searchRes.getControlActProcess().getQueryAck().getQueryResponseCode();
		// good MVI response
		if (queryResponseCode.getCode().equals(MviResponseTypeEnum.GOOD_RESPONSE.getResType())) {
			// fetch ICN from MVI search result
			ICNFromMviResponse = getICNfromSearchResult(searchRes);
			if(ICNFromMviResponse == null) {
				// Don't do anything coz no ICN found in MVI response
				activityService.auditMviEvent(userProfile, ActivityActorTypeEnumeration.SYSTEM,false, ActivityActionTypeEnumeration.UPGRADE_TO_ADVANCED,ActivityTypeEnumeration.ACCOUNT_UPGRADE, response);
				return ;
			} else {
				//JAZZ Task#20972 - Check SSN from 1306 MVI response message and display error if SSN is different from MHV Patient
				String SSNFromMviResponse = null;
				PRPAIN201305UV02 searchXmlObj = null;
				try {
					PRPAIN201305UV02Document searchXmlObjRoot = PRPAIN201305UV02Document.Factory.parse((String) searchReqXML);
					searchXmlObj = searchXmlObjRoot.getPRPAIN201305UV02();
				} catch (Exception ex) {
					log.error("Error in parsing MVI search response " + searchReqXML, ex);
					response.setFailureMessage("Error in parsing MVI search response");
					response.setSuccess(false);
					response.setFailure(true);
					return;
				}

				// fetch SSN from MVI search result
				SSNFromMviResponse = getSSNfromSearchResult(searchXmlObj, searchRes);
				String numberOnlySsn = StringUtils.replace(userProfile.getSsn(), "-", "");
				if(SSNFromMviResponse==null || !(numberOnlySsn.equals(SSNFromMviResponse))) {
					response.getInfoMessages().put(messagesUtil.getMviUpdateAdvancedFailureResponse() ,
						String.format(messagesUtil.getMviUpdateAdvancedFailureResponse(), mviProperties.getAdvancedUrl(), mviProperties.getTargetWindow(),
							mviProperties.getContactMhvUrl(), mviProperties.getTargetWindow()));
					return;
				}

				activityService.auditMviEvent(userProfile,ActivityActorTypeEnumeration.SYSTEM,true, ActivityActionTypeEnumeration.UPGRADE_TO_ADVANCED, ActivityTypeEnumeration.ACCOUNT_UPGRADE, response);

				//JAZZ:17155 - During match handle different ICN coming from MVI
				if (null != existingPatient && !existingPatient.getIcn().equals(ICNFromMviResponse)) {
					patientService.getPatientByIcn(ICNFromMviResponse, response);
					if ( response.getPojoObject() != null &&  ((Patient)response.getPojoObject()).getId() != null) {
						log.info("During Login in the match process ICN from MVI: " + ICNFromMviResponse +
							" is different from evault.patient ICN: " + existingPatient.getIcn() +
							" ICN from MVI belongs to another patient with user profile id: " + ((Patient)response.getPojoObject()).getUserProfile().getId());
						return;
					} else {
						existingPatient.setIcn(ICNFromMviResponse);
						patientService.updatePatientRegistryInformation(existingPatient, response);
					}
				}

				if (existingPatient == null || existingPatient.getIcn().equals(ICNFromMviResponse) ) {
					if (existingPatient == null) {
						vetPatient = new Patient();
						vetPatient.setIcn(ICNFromMviResponse);
						vetPatient.setUserProfile(userProfile);
					}
					if (log.isDebugEnabled())
						log.debug("Existing Patients ICN Matched with MVI Response ICN OR Dealing with Existing Veteran");
					if (searchRes.getControlActProcess().getSubjectArray() != null ) {
						PRPAIN201306UV02MFMIMT700711UV01Subject1[] subjectSearchArray = searchRes.getControlActProcess().getSubjectArray();
						if(subjectSearchArray[0].getRegistrationEvent() != null) {
							PRPAMT201310UV02Patient searchResultPatient = subjectSearchArray[0].getRegistrationEvent().getSubject1().getPatient();
							II[] searchPatientIdArray = searchResultPatient.getIdArray();
							// Updating the facilities with the newer ones we received from MVI
							if (vetPatient == null)
								processFacilityChanges(receivedFacilitiesFromMvi(searchPatientIdArray), existingPatient, userProfile);
							else
								processFacilityChanges(receivedFacilitiesFromMvi(searchPatientIdArray), vetPatient, userProfile);
						}
					}
					if(vetPatient == null) {
						existingPatient.setCorrelationStatus(PatientCorrelationStatusEnumeration.MVIDATAMATCH.getValue());
						existingPatient.setMatchedDateTime(new Timestamp(Calendar.getInstance().getTime().getTime()));

						// Now we will update the Authentication Status
						this.addPersonForCorrelation(existingPatient, userProfile, false, response, MviUtil.getVersionInfo(userProfile));

						InPersonAuthentication ipaPatient = null;
						ipaService.getIPAPatientById(existingPatient.getId(), response);
						if (response.isFailure()) {
							return;
						} else {
							ipaPatient = (InPersonAuthentication) response.getPojoObject();
						}

						if(ipaPatient != null) {
							if (ipaPatient.getStatus().equals(AuthenticationStatusEnumeration.AUTHENTICATED)) {
								ipaPatient.setMviAuthenticationStatus("PENDING_AUTH");
								ipaPatient.setAuthenticationDate(new Timestamp(new Date().getTime()));
								ipaPatient.setAuthenticatedBy(ActivityActorTypeEnumeration.SYSTEM.getDescription());

								ipaService.saveIPA(ipaPatient);
								existingPatient.setPatientSynchronizations(null);
							} else if (ipaPatient.getStatus().equals(AuthenticationStatusEnumeration.PENDINGDATAMISMATCH)) {
								ipaPatient.setStatus(AuthenticationStatusEnumeration.AUTHENTICATED.getDescription());
								ipaPatient.setMviAuthenticationStatus("PENDING_AUTH");
								ipaPatient.setAuthenticationDate(new Timestamp(new Date().getTime()));
								ipaPatient.setAuthenticatedBy(ActivityActorTypeEnumeration.SYSTEM.getDescription());

								ipaService.saveIPA(ipaPatient);
							}
						}
					} else {
						vetPatient.setCorrelationStatus(PatientCorrelationStatusEnumeration.MVIDATAMATCH.getValue());
						vetPatient.setMatchedDateTime(new Timestamp(Calendar.getInstance().getTime().getTime()));
						addVetForCorrelation(vetPatient, userProfile, response, MviUtil.getVersionInfo(userProfile));
						if (response.isFailure()) {
							return;
						}
						//if (resp.getBoolean().booleanValue())
						Patient savedPatient = patientService.savePatient(vetPatient);
						response.setPojoObject(savedPatient);
					}
					Set<Facility> facilitiesList = new HashSet<Facility>();
					if(vetPatient != null)
						facilitiesList = vetPatient.getFacilities();
					else
						facilitiesList = existingPatient.getFacilities();

					List<String> stationNumberArray = new ArrayList<String>();
					for (Facility facility : facilitiesList) {
						stationNumberArray.add(facility.getName());
					}
					if(MviUtil.checkTreatmentFacilitiesExist(stationNumberArray))
						userProfile.setIsPatient(true);
					else {
						userProfile.setIsPatient(false);
						userProfile.setIsVeteran(true);
					}
					userProfile.setIsMPIControlled(true);
					//ServiceFactory.createEntityMaintenanceService().save(userProfile);
					try {
						userProfileRepository.save(userProfile);
					} catch (Exception e) {
						log.error("Error in storing userProfile details " + userProfile, e);
						response.setFailure(true);
						response.setFailureMessage("Error in storing userProfile details " + userProfile);
						return;
					}

				} else {
					if (log.isInfoEnabled()) {
						log.info("Existing Patients ICN does not match MVI Response ICN. Existing ICN:" + existingPatient.getIcn() + ". Received ICN: " +
							ICNFromMviResponse + " For User: " + existingPatient.getUserProfile().getId());
					}
				}
			}
		} else {
			// MVI response has and error
			if (queryResponseCode.getCode().equals(MviResponseTypeEnum.QUERY_ERROR.getResType())){
				if (log.isErrorEnabled())
					log.error("Max Results Exceeded in MVI: "+queryResponseCode.getCode() + " for user profile id: " + userProfile.getId());
			} else if (queryResponseCode.getCode().equals(MviResponseTypeEnum.APPLICATION_ERROR.getResType())){
				if(log.isErrorEnabled())
					log.error("Application Error in MVI: "+queryResponseCode.getCode()+ " for user profile id: " + userProfile.getId());
				response.getInfoMessages().put(messagesUtil.getMviParseResponseAeIssue(), messagesUtil.getMviParseResponseAeIssue());
				return;
			} else if(queryResponseCode.getCode().equals(MviResponseTypeEnum.NOT_FOUND.getResType())) {
				activityService.auditMviEvent(userProfile, ActivityActorTypeEnumeration.SYSTEM, false, ActivityActionTypeEnumeration.UPGRADE_TO_ADVANCED, ActivityTypeEnumeration.ACCOUNT_UPGRADE, response);
				if(log.isErrorEnabled())
					log.error("User not found in MVI: "+queryResponseCode.getCode()+ " for user profile id: " + userProfile.getId());
			}
			return;
		}
	}

	private String getSSNfromSearchResult(PRPAIN201305UV02 searchReqXML, PRPAIN201306UV02 searchRes) {
		String mcidUniqValueSent = searchReqXML.getControlActProcess().getQueryByParameter().getQueryId().getExtension();
		String mcidUniqValueRecd = searchRes.getControlActProcess().getQueryAck().getQueryId().getExtension();

		if (mcidUniqValueSent.equals(mcidUniqValueRecd)) {
			PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1Array[] = searchRes.getControlActProcess().getSubjectArray();
			PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1 = subject1Array[0];
			PRPAMT201310UV02Patient patient = subject1.getRegistrationEvent().getSubject1().getPatient();
			PRPAMT201310UV02OtherIDs[] otherIds = patient.getPatientPerson().getAsOtherIDsArray();
			for (int i = 0; i < otherIds.length; i++) {
				PRPAMT201310UV02OtherIDs otherId = otherIds[i];
				// JAZZ Defect # 29216 - MVI correlation issue - User with Alias
				// SSN will not be matched or correlated- Fix:Made sure that the
				// SSN is compared with equals instead of contains
				if (otherId.getClassCode().equals("SSN")) {
					II idArray[] = otherId.getIdArray();
					for (II id: idArray ) {
						return id.getExtension();
					}
				}
			}
		} else {
			log.info("Request MCID did NOT match with Response MCID");
		}
		return null;
	}

/*    private InPersonAuthentication saveIPA(InPersonAuthentication ipa,
            AuthenticationStatus status) {
        InPersonAuthenticationBO bo = BusinessObjectFactory
            .createInPersonAuthenticationBO();
        ipa = bo.saveAndUpdateStatus(ipa, status);
        return ipa;
    }*/

	public void mviAuthenticate(Patient patient, UserProfile userProfile, Boolean authenticate, Boolean batch, String versionInfo) {/*
		//return ServiceFactory.createMviIntegrationService().mviAuthenticate(patient, userProfile, authenticate, batch);
		InPersonAuthenticationServiceResponse ipaResponse =
			ServiceFactory.createInPersonAuthenticationService().getIPAPatientById(patient.getId());
		InPersonAuthentication ipa = ipaResponse.getInPersonAuthentication();
        AuthenticationStatus status = InPersonAuthenticationStatusUtils.AUTHENTICATED;
        ipa.setAuthenticationDate(new Timestamp(new Date().getTime()));
        ipa = saveIPA(ipa, status);

        BooleanServiceResponse patientServiceResponse = new BooleanServiceResponse();
        patientServiceResponse.setBoolean(false);

        if (!hasErrorMessages(ipaResponse)) {
			patientServiceResponse = ServiceFactory.createMviIntegrationService().mviAuthenticate(
				patient, patient.getUserProfile(), true, false);
            if (patientServiceResponse.getBoolean()) {
            	ipa.setMviAuthenticationStatus("OK");
                ipa = saveIPA(ipa, status);
            } else {
            	ipa.setMviAuthenticationStatus("PENDING_AUTH");
            	ipa = saveIPA(ipa, status);
            }
        }

        return patientServiceResponse;
	*/}

	public void mviUnauthenticateUncorrelateForBatch(Patient patient, UserProfile userProfile, String adminUserName, String versionInfo) {/*
		InPersonAuthenticationServiceResponse ipaResponse =
			ServiceFactory.createInPersonAuthenticationService().getIPAPatientById(patient.getId());
		InPersonAuthentication ipa = ipaResponse.getInPersonAuthentication();
        Precondition.assertNotNull("ipa", ipa);
        Precondition.assertNotNull("ipa.patient", ipa.getPatient());
        BooleanServiceResponse response = new BooleanServiceResponse();
        response.setBoolean(false);
        AuthenticationStatus status = InPersonAuthenticationStatusUtils.UNAUTHENTICATED;
        ipa.setParticipationFormSigned(Boolean.FALSE);
        ipa.setIdentificationPresented(Boolean.FALSE);
        ipa.setApprovedForRecordsAccess(Boolean.FALSE);
        ipa.setDefermentReason(null);
        ipa.setAuthenticatingFacility(null);
        ipa.setAuthenticationDate(null);
        ipa = saveIPA(ipa, status);

        //response.setInPersonAuthentication(ipa);
        copyMessages(response, ipa);
        if (!hasErrorMessages(response)) {
			//MHV_CodeCR1514 - US12.4 MVI Compliance Implementation - If the MVI flag is turned on call, MVI call instead of MPI call
            BooleanServiceResponse patientServiceResponse = null;
			ipa.setMviAuthenticationStatus("PENDING_UNAUTH");
            if (!hasErrorMessages(response)) {
    			//MHV_CodeCR1514 - US12.4 MVI Compliance Implementation - If the MVI flag is turned on call, MVI call instead of MPI call
				patientServiceResponse = ServiceFactory.
                createPatientService().mviUnauthenticate(ipa.getPatient());
                if (patientServiceResponse.getBoolean()) {
                    if (log.isDebugEnabled()) {
                        log.debug("InPersonAuthenticationServiceImpl.mviUnauthenticate():SUCCESS unauthenticating patient with ICN:" + ipa.getPatient().getIcn());
                    }
        			//MHV_CodeCR1918 - US12.4.x MVI Compliance Implementation - If the patient status is correleated or pending corr/uncorr
                    //try to uncorrelate. Only
                	if(ipa.getPatient().getCorrelationStatus() == PatientCorrelationStatus.getEnum(PatientCorrelationStatus.CORRELATED)||
                	   ipa.getPatient().getCorrelationStatus() == PatientCorrelationStatus.getEnum(PatientCorrelationStatus.PENDINGCORRELATION)||
                	   ipa.getPatient().getCorrelationStatus() == PatientCorrelationStatus.getEnum(PatientCorrelationStatus.PENDINGUNCORRELATION)) {
	                	PatientServiceResponse patientResponse =
	        				ServiceFactory.createMviIntegrationService().deletePersonFromCorrelationForIPA(ipa.getPatient(), ipa.getPatient().getUserProfile(), "");
	        			if (patientResponse.getPatient().getCorrelationStatus() == PatientCorrelationStatus.getEnum(PatientCorrelationStatus.MVIDATAMATCH)) {
	        				//Only when both unauthenticate and uncorrelate are successful, we set to OK flag
	        				ipa.setMviAuthenticationStatus("OK");
	                        if (log.isDebugEnabled()) {
	                            log.debug("InPersonAuthenticationServiceImpl.mviUnauthenticate():SUCCESS uncorrelating patient with ICN:" + ipa.getPatient().getIcn());
	                        }
	                        response.setBoolean(true);
	        			} else {
	                        if (log.isDebugEnabled()) {
	                            log.debug("InPersonAuthenticationServiceImpl.mviUnauthenticate():ERROR uncorrelating patient with ICN:" + ipa.getPatient().getIcn());
	                        }
	        			}
                	}
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("InPersonAuthenticationServiceImpl.mviUnauthenticate():ERROR unauthenticating patient with ICN:" + ipa.getPatient().getIcn());
                    }

                }
            }
            ipa = saveIPA(ipa, status);
        }
        return response;
	*/}

	@SuppressWarnings("unused")
	private void addVetForCorrelation(Patient patient, UserProfile userProfile, ResponseUtil response, String versionInfo) {
		Object correlationReqXML = createMVICorrelationRequest.createCorrelationXMLRequest(userProfile,patient, mviProperties, versionInfo);
		patient.setCorrelateRequestDateTime(new Timestamp(Calendar.getInstance().getTime().getTime()));
		String responseXMLString = mviInvocationUtilHandler.invokeMvi(MviRequestTypeEnum.ADDCORRELATION_TYPE.getReqType(), correlationReqXML);
		MVIMessageParser messageParser = new MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.ADDCORRELATION_TYPE.getReqType(), (String)correlationReqXML, responseXMLString);

		if (searchObj == null) {
			if (log.isErrorEnabled()) {
				log.error("UNABLE TO PARSE THE CORRELATION RESPONSE FROM MVI For the ICN: "+patient.getIcn());
			}
			response.setFailure(true);
			response.setFailureMessage("UNABLE TO PARSE THE CORRELATION RESPONSE FROM MVI For the ICN: "+patient.getIcn());
		} else {
			MCCIIN000002UV01 searchCorrelRes = (MCCIIN000002UV01)searchObj;
			MCCIMT000200UV01Acknowledgement[] acknowledgementArray = searchCorrelRes.getAcknowledgementArray();
			MCCIMT000200UV01Acknowledgement acknowledgement = null;
			acknowledgement = acknowledgementArray[0];
			//}
			if(acknowledgement.getTypeCode().getCode().equals("AA")) {
				MCCIMT000200UV01AcknowledgementDetail[]  acknowledgementDetailArray = acknowledgement.getAcknowledgementDetailArray();
				MCCIMT000200UV01AcknowledgementDetail acknowledgementDetail =acknowledgementDetailArray[0];
				patient.setCorrelatedDateTime(new Timestamp(Calendar.getInstance().getTime().getTime()));
				patient.setCorrelationStatus(PatientCorrelationStatusEnumeration.CORRELATED.getValue());
				//Admin Portal_CodeCR1747 - Changed from SYSTEM to System
				patient.setCorrelatedBy("System");
				activityService.auditMviEvent(userProfile, ActivityActorTypeEnumeration.SYSTEM, true, ActivityActionTypeEnumeration.CONNECTED_TO_VA_RECORD, ActivityTypeEnumeration.ACCOUNT_UPGRADE, response);
				response.setSuccess(true);
			} else {
				patient.setCorrelationStatus(PatientCorrelationStatusEnumeration.FAILEDCORRELATION.getValue());
			}
		}

		return;

	}

	private String getICNfromSearchResult(PRPAIN201306UV02 searchRes) {
		PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1Array[] = searchRes
				.getControlActProcess().getSubjectArray();
		PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1 = subject1Array[0];
		PRPAMT201310UV02Patient patient = subject1.getRegistrationEvent()
				.getSubject1().getPatient();
		II idArray[] = patient.getIdArray();
		for (int i = 0; i < idArray.length; i++) {
			II patientId = idArray[i];
			String searchIdExtension = patientId.getExtension();
			if (searchIdExtension.contains("NI")) {
				String[] idExtn = searchIdExtension.split("\\^");
				String source = idExtn[2];
				String issuer = idExtn[3];
				if (source.equals("200M") && issuer.equals("USVHA")) {
					String patientICN = idExtn[0];
					return patientICN;
				}
			}
		}
		return null;
	}

	private Set<Facility> processFacilityChanges(Map<String, Facility> receivedfacilityNames, Patient existingPatient, UserProfile userProfile) {
		Map<String, Facility> oldFacilities = collectStationNumbers(existingPatient);
		if (!CollectionUtils.isEqualCollection(receivedfacilityNames.keySet(),oldFacilities.keySet()))
		{
			PatientRegistryChange changeRec = getChangeRecord("Facilities", userProfile);
			changeRec.setOldFacilityCount(existingPatient.getFacilities().size());
			existingPatient.addPatientRegistryChange(changeRec);
			Set<Facility> facilities = new HashSet<Facility>();
			for (String stationNumber: receivedfacilityNames.keySet()) {
				Facility facility = oldFacilities.get(stationNumber);
				if (facility == null) {
					if (log.isDebugEnabled()) {
						log.debug("Adding facility in evault from MVI " + stationNumber
								+ "'");
					}
					facility = receivedfacilityNames.get(stationNumber);
				} else {
					if (log.isDebugEnabled()) {
						log.debug("Keeping facility exists in evault'" + stationNumber +
								"' (" + facility.getId() + ")");
					}
				}
				facilities.add(facility);
			}
			if (log.isDebugEnabled()) {
				for (String stationNumber: oldFacilities.keySet()) {
					Facility facility = receivedfacilityNames.get(stationNumber);
					if (facility == null) {
						log.debug("Removing facilities from evault with respect to the MVI response '" + stationNumber
								+ "'");
					}
				}
			}
			
//			for (Facility facility : facilities) {
//				facility.setPatient(existingPatient);
//				facilityRepository.save(facility);
//			}
			//existingPatient.setFacilities(facilities);
			return facilities;
		}
		return null;
	}

	private Map<String, Facility> collectStationNumbers(Patient patient) {
		assert patient != null : "Must provide a patient";
		Map<String, Facility> facilityNames =
			new HashMap<String, Facility>();
		for (Object f: patient.getFacilities()) {
			Facility facility = (Facility) f;
			facilityNames.put(facility.getName(), facility);
		}
		return facilityNames;
	}

	public Map<String, Facility> receivedFacilitiesFromMvi(II[]searchPatientIdArray) {
		Map<String, Facility> receivedfacilityNames = new HashMap<String, Facility>();
		for (int i=0; i< searchPatientIdArray.length; i++) {
			II patientId = searchPatientIdArray[i];
			String searchIdExtension = patientId.getExtension();
			if (searchIdExtension.contains("PI") || searchIdExtension.contains("NI")) {
				String[] idExtn = searchIdExtension.split("\\^");
				String stationNumber = idExtn[2];
				String facilityStatus = idExtn[4];
				if(facilityStatus.equalsIgnoreCase("A")) {
					if(!StringUtils.isBlank(stationNumber) ) {
						Facility facility = new Facility();
						facility.setName(stationNumber);
						receivedfacilityNames.put(stationNumber, facility);
						receivedfacilityNames.put(facility.getName(), facility);
					}
				}
			}
		}
		return receivedfacilityNames;
	}


	private PatientRegistryChange getChangeRecord(String forProperty, UserProfile userProfile) {
		if (log.isDebugEnabled()) {
			log.debug("found " + forProperty + " change for " + userProfile.getUserName());
		}

		PatientRegistryChange changeRecord = new PatientRegistryChange();
		changeRecord.setRecordedOnDate(new Timestamp(System.currentTimeMillis()));

		return changeRecord;
	}

}